#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

int compare(const void *a, const void *b) {
    return (*(long long *)a - *(long long *)b);
}

int main() {
    int numRows, numCols, subRows, subCols;
    scanf("%d %d %d %d", &numRows, &numCols, &subRows, &subCols);
    long long *arrayA = (long long *)malloc(numRows * numCols * sizeof(long long));
    for (int i = 0; i < numRows * numCols; i++) {
        scanf("%lld", &arrayA[i]);
    }
    long long **matrixA = (long long **)malloc(numRows * sizeof(long long *));
    for (int i = 0; i < numRows; i++) {
        matrixA[i] = (long long *)malloc(numCols * sizeof(long long));
        for (int j = 0; j < numCols; j++) {
            matrixA[i][j] = arrayA[i * numCols + j];
        }
    }
    long long maxVal = LLONG_MIN;
    int maxRowIdx = 0;
    int maxColIdx = 0;
    for (int i = 0; i < numRows; i++) {
        for (int j = 0; j < numCols; j++) {
            if (matrixA[i][j] > maxVal) {
                maxVal = matrixA[i][j];
                maxRowIdx = i;
                maxColIdx = j;
            }
        }
    }
    long long tmp = matrixA[numRows / 2][numCols / 2];
    matrixA[numRows / 2][numCols / 2] = maxVal;
    matrixA[maxRowIdx][maxColIdx] = tmp;
    long long **sortedMatrix = (long long **)malloc(numRows * sizeof(long long *));
    for (int i = 0; i < numRows; i++) {
        sortedMatrix[i] = (long long *)malloc(numCols * sizeof(long long));
        qsort(matrixA[i], numCols, sizeof(long long), compare);
        int idx = numCols / 2;
        for (int j = 0; j < numCols; j++) {
            sortedMatrix[i][j] = matrixA[i][(j + idx) % numCols];
        }
    }
    long long ***submatrices = (long long ***)malloc((numRows - subRows + 1) * sizeof(long long **));
    for (int i = 0; i < numRows - subRows + 1; i++) {
        submatrices[i] = (long long **)malloc((numCols - subCols + 1) * sizeof(long long *));
        for (int j = 0; j < numCols - subCols + 1; j++) {
            submatrices[i][j] = (long long *)malloc(subRows * subCols * sizeof(long long));
            for (int k = 0; k < subRows; k++) {
                for (int l = 0; l < subCols; l++) {
                    submatrices[i][j][k * subCols + l] = sortedMatrix[i + k][j + l];
                }
            }
        }
    }
    long long totalSum = 0;
    for (int i = 0; i < numRows - subRows + 1; i++) {
        for (int j = 0; j < numCols - subCols + 1; j++) {
            for (int k = 0; k < subRows * subCols; k++) {
                totalSum += submatrices[i][j][k];
            }
        }
    }
    printf("%lld\n", totalSum);
    for (int i = 0; i < numRows; i++) {
        free(matrixA[i]);
        free(sortedMatrix[i]);
    }
    free(matrixA);
    free(sortedMatrix);
    for (int i = 0; i < numRows - subRows + 1; i++) {
        for (int j = 0; j < numCols - subCols + 1; j++) {
            free(submatrices[i][j]);
        }
        free(submatrices[i]);
    }
    free(submatrices);
    free(arrayA);
    return 0;
}